/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.command.CmdClone;
import noppes.npcs.command.CmdConfig;
import noppes.npcs.command.CmdDialog;
import noppes.npcs.command.CmdDimensions;
import noppes.npcs.command.CmdFaction;
import noppes.npcs.command.CmdHelp;
import noppes.npcs.command.CmdMark;
import noppes.npcs.command.CmdNPC;
import noppes.npcs.command.CmdPlayers;
import noppes.npcs.command.CmdQuest;
import noppes.npcs.command.CmdScene;
import noppes.npcs.command.CmdSchematics;
import noppes.npcs.command.CmdScript;
import noppes.npcs.command.CmdSlay;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;

public class CommandNoppes
extends CommandBase {
    public CmdHelp help;
    public final Map<String, CommandNoppesBase> map = new HashMap<String, CommandNoppesBase>();

    public CommandNoppes() {
        this.help = new CmdHelp(this);
        this.registerCommand(this.help);
        this.registerCommand(new CmdScript());
        this.registerCommand(new CmdScene());
        this.registerCommand(new CmdSlay());
        this.registerCommand(new CmdQuest());
        this.registerCommand(new CmdDialog());
        this.registerCommand(new CmdSchematics());
        this.registerCommand(new CmdFaction());
        this.registerCommand(new CmdNPC());
        this.registerCommand(new CmdClone());
        this.registerCommand(new CmdConfig());
        this.registerCommand(new CmdMark());
        this.registerCommand(new CmdDimensions());
        this.registerCommand(new CmdPlayers());
    }

    @Nonnull
    public String func_71517_b() {
        return "noppes";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length == 0) {
            this.help.func_184881_a(server, sender, args);
            return;
        }
        CommandNoppesBase command = this.getCommand(args);
        if (command == null) {
            throw new CommandException("Unknown command " + args[0], new Object[0]);
        }
        args = Arrays.copyOfRange(args, 1, args.length);
        if (command.subcommands.isEmpty() || !command.runSubCommands()) {
            if (command.func_82362_a() > this.getPermissionLevel(server, sender)) {
                throw new CommandException("You are not allowed to use \"" + command.func_71517_b().toLowerCase() + "\" command", new Object[0]);
            }
            command.canRun(server, sender, command.getUsage(), args);
            command.func_184881_a(server, sender, args);
        } else {
            if (args.length == 0) {
                this.help.func_184881_a(server, sender, new String[]{command.func_71517_b()});
                return;
            }
            command.executeSub(server, sender, args[0], Arrays.copyOfRange(args, 1, args.length));
        }
    }

    public CommandNoppesBase getCommand(String[] args) {
        if (args.length == 0) {
            return null;
        }
        return this.map.get(args[0].toLowerCase());
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, BlockPos pos) {
        int p;
        CommandNoppesBase.SubCommand sc;
        int per = this.getPermissionLevel(server, sender);
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, CommandNoppesBase> entry : this.map.entrySet()) {
                if (entry.getValue().func_82362_a() > per) continue;
                list.add(entry.getKey());
            }
            return CommandBase.func_175762_a((String[])args, list);
        }
        CommandNoppesBase command = this.getCommand(args);
        if (command == null) {
            return new ArrayList<String>();
        }
        if (args.length == 2 && command.runSubCommands()) {
            ArrayList<String> list = new ArrayList<String>();
            for (String name : command.subcommands.keySet()) {
                CommandNoppesBase.SubCommand sc2 = command.subcommands.get(name).getAnnotation(CommandNoppesBase.SubCommand.class);
                if (sc2 == null || sc2.permission() > per) continue;
                list.add(name);
            }
            return CommandBase.func_175762_a((String[])args, list);
        }
        String[] useArgs = command.getUsage().split(" ");
        if (command.runSubCommands() && (sc = command.subcommands.get(args[1].toLowerCase()).getAnnotation(CommandNoppesBase.SubCommand.class)) != null) {
            useArgs = sc.usage().split(" ");
        }
        int s = 3;
        if (command.func_71517_b().equals("faction")) {
            s = 2;
        }
        if ((p = args.length - s) >= 0 && p < useArgs.length) {
            String usage;
            switch (usage = useArgs[p]) {
                case "<player>": 
                case "[player]": {
                    return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
                case "<quest>": 
                case "[quest]": {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int id : QuestController.instance.quests.keySet()) {
                        list.add("" + id);
                    }
                    return list;
                }
                case "<dialog>": 
                case "[dialog]": {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int id : DialogController.instance.dialogs.keySet()) {
                        list.add("" + id);
                    }
                    return list;
                }
                case "<faction>": 
                case "[faction]": {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int id : FactionController.instance.factions.keySet()) {
                        list.add("" + id);
                    }
                    return list;
                }
            }
        }
        return command.func_184883_a(server, sender, Arrays.copyOfRange(args, 1, args.length), pos);
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "Use as /noppes subcommand";
    }

    public void registerCommand(CommandNoppesBase command) {
        String name = command.func_71517_b().toLowerCase();
        if (this.map.containsKey(name)) {
            throw new CustomNPCsException("Already a subcommand with the name: " + name, new Object[0]);
        }
        this.map.put(name, command);
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        int thisPer = this.func_82362_a();
        if (sender instanceof EntityPlayerMP) {
            return thisPer <= this.getPermissionLevel(server, sender);
        }
        return sender.func_70003_b(thisPer, this.func_71517_b());
    }

    protected int getPermissionLevel(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        int per = 4;
        if (sender instanceof EntityPlayerMP) {
            per = 0;
            UserListOpsEntry util = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)((EntityPlayerMP)sender).func_146103_bH());
            if (util != null) {
                per = util.func_152644_a();
            }
            if (((EntityPlayerMP)sender).func_184812_l_()) {
                per = Math.max(server.func_71264_H() ? 4 : 2, per);
            }
        }
        return per;
    }
}

